/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.state;

import java.awt.Color;
import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.autoplot.MouseModuleType;
import org.autoplot.RenderType;
import org.autoplot.dom.BindingModel;
import org.autoplot.dom.Connector;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;
import org.autoplot.state.BindingModelSerializeDelegate;
import org.autoplot.state.ColorSerializeDelegate;
import org.autoplot.state.ConnectorSerializeDelegate;
import org.autoplot.state.DatumSerializeDelegate;
import org.autoplot.state.LevelSerializeDelegate;
import org.autoplot.state.TypeSafeEnumSerializeDelegate;
import org.autoplot.state.VapScheme;
import org.das2.beans.BeansUtil;
import org.das2.datum.Datum;
import org.das2.graph.AnchorPosition;
import org.das2.graph.AnchorType;
import org.das2.graph.BorderType;
import org.das2.graph.DasColorBar;
import org.das2.graph.DefaultPlotSymbol;
import org.das2.graph.ErrorBarType;
import org.das2.graph.LegendPosition;
import org.das2.graph.PlotSymbol;
import org.das2.graph.PsymConnector;
import org.das2.graph.SpectrogramRenderer;
import org.das2.qstream.SerializeDelegate;
import org.das2.qstream.SerializeRegistry;
import org.das2.qstream.XMLSerializeDelegate;
import org.das2.util.LoggerManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SerializeUtil {
    private static final Logger logger = LoggerManager.getLogger((String)"autoplot.dom.vap");

    public static Element getDomElement(Document document, DomNode node, VapScheme scheme) {
        return SerializeUtil.getDomElement(document, node, scheme, true);
    }

    public static Element getDomElement(Document document, DomNode node, VapScheme scheme, boolean includeDefaults) {
        try {
            PropertyDescriptor[] properties;
            String elementName = scheme.getName(node.getClass());
            DomNode defl = (DomNode)node.getClass().newInstance();
            Element element = document.createElement(elementName);
            BeanInfo info = BeansUtil.getBeanInfo(node.getClass());
            for (PropertyDescriptor pd : properties = info.getPropertyDescriptors()) {
                Element child;
                Object value1;
                int j;
                String clasName;
                Element propertyElement;
                Object value;
                String propertyName = pd.getName();
                if (propertyName.equals("class") || propertyName.equals("controller")) continue;
                boolean connectorKludge107 = false;
                if (propertyName.equals("connectors")) {
                    connectorKludge107 = true;
                }
                if (propertyName.endsWith("Automatically")) continue;
                logger.log(Level.FINE, "serializing property \"{0}\" of {1} id={2}", new Object[]{propertyName, elementName, node.getId()});
                Method readMethod = pd.getReadMethod();
                Method writeMethod = pd.getWriteMethod();
                if (writeMethod == null || readMethod == null) {
                    logger.log(Level.FINE, "skipping property \"{0}\" of {1}, failed to find read and write method.", new Object[]{propertyName, elementName});
                    continue;
                }
                try {
                    value = readMethod.invoke((Object)node, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    logger.log(Level.SEVERE, ex.getMessage(), ex);
                    continue;
                }
                if (value == null) {
                    logger.log(Level.INFO, "skipping property {0} of {1}, value is null.", new Object[]{propertyName, elementName});
                    continue;
                }
                if (propertyName.equals("id") && ((String)value).length() > 0) {
                    element.setAttribute(propertyName, (String)value);
                    continue;
                }
                IndexedPropertyDescriptor ipd = null;
                if (pd instanceof IndexedPropertyDescriptor) {
                    ipd = (IndexedPropertyDescriptor)pd;
                }
                if (value instanceof DomNode) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", propertyName);
                    propertyElement.setAttribute("type", "DomNode");
                    Element child2 = SerializeUtil.getDomElement(document, (DomNode)value, scheme, includeDefaults);
                    propertyElement.appendChild(child2);
                    element.appendChild(propertyElement);
                    continue;
                }
                if (ipd != null && !connectorKludge107 && DomNode.class.isAssignableFrom(ipd.getIndexedPropertyType())) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", propertyName);
                    clasName = scheme.getName(ipd.getIndexedPropertyType());
                    propertyElement.setAttribute("class", clasName);
                    propertyElement.setAttribute("length", String.valueOf(Array.getLength(value)));
                    for (j = 0; j < Array.getLength(value); ++j) {
                        value1 = Array.get(value, j);
                        child = SerializeUtil.getDomElement(document, (DomNode)value1, scheme, includeDefaults);
                        propertyElement.appendChild(child);
                    }
                    element.appendChild(propertyElement);
                    continue;
                }
                if (ipd != null) {
                    propertyElement = document.createElement("property");
                    propertyElement.setAttribute("name", propertyName);
                    clasName = scheme.getName(ipd.getIndexedPropertyType());
                    propertyElement.setAttribute("class", clasName);
                    propertyElement.setAttribute("length", String.valueOf(Array.getLength(value)));
                    for (j = 0; j < Array.getLength(value); ++j) {
                        value1 = Array.get(value, j);
                        child = SerializeUtil.getElementForLeafNode(document, ipd.getIndexedPropertyType(), value1, null);
                        propertyElement.appendChild(child);
                    }
                    element.appendChild(propertyElement);
                    continue;
                }
                Object defltValue = DomUtil.getPropertyValue(defl, pd.getName());
                if (value.equals(defltValue) && !includeDefaults) continue;
                Element prop = SerializeUtil.getElementForLeafNode(document, pd.getPropertyType(), value, defltValue);
                if (prop == null) {
                    logger.log(Level.WARNING, "unable to serialize {0}", propertyName);
                    continue;
                }
                prop.setAttribute("name", pd.getName());
                element.appendChild(prop);
            }
            return element;
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    public static Element getElementForLeafNode(Document document, Class propClass, Object value, Object defltValue) {
        boolean isDef = defltValue == value || defltValue != null && defltValue.equals(value);
        SerializeDelegate sd = SerializeRegistry.getDelegate((Class)propClass);
        if (sd == null) {
            return null;
        }
        Element prop = document.createElement("property");
        if (sd instanceof XMLSerializeDelegate) {
            prop.appendChild(((XMLSerializeDelegate)sd).xmlFormat(document, value));
            prop.setAttribute("type", sd.typeId(value.getClass()));
        } else {
            prop.setAttribute("type", sd.typeId(value.getClass()));
            prop.setAttribute("value", sd.format(value));
            if (!isDef) {
                if (defltValue == null) {
                    prop.setAttribute("default", "null");
                } else {
                    prop.setAttribute("default", sd.format(defltValue));
                }
            }
        }
        return prop;
    }

    private static Element firstChildElement(Element element) {
        NodeList nl = element.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (!(nl.item(i) instanceof Element)) continue;
            return (Element)nl.item(i);
        }
        throw new IllegalArgumentException("Element has no children that are elements");
    }

    public static Object getLeafNode(Element element) throws ParseException {
        String type = element.getAttribute("type");
        SerializeDelegate sd = SerializeRegistry.getByName((String)type);
        if (sd == null) {
            throw new IllegalArgumentException("unable to find serialize delegate for \"" + type + "\"");
        }
        if (element.hasChildNodes()) {
            return ((XMLSerializeDelegate)sd).xmlParse(SerializeUtil.firstChildElement(element));
        }
        return sd.parse(type, element.getAttribute("value"));
    }

    public static DomNode getDomNode(Element element, VapScheme scheme) throws ParseException {
        try {
            String clasName = element.getNodeName();
            Class claz = scheme.getClass(clasName);
            if (claz == null) {
                logger.log(Level.WARNING, "unable to resolve: {0}", element.getTagName());
                throw new ParseException("unable to resolve class: " + clasName, 0);
            }
            DomNode node = (DomNode)claz.newInstance();
            BeanInfo info = BeansUtil.getBeanInfo(node.getClass());
            PropertyDescriptor[] properties = info.getPropertyDescriptors();
            HashMap<String, PropertyDescriptor> pp = new HashMap<String, PropertyDescriptor>();
            for (PropertyDescriptor property : properties) {
                pp.put(property.getName(), property);
            }
            if (element.hasAttribute("id")) {
                node.setId(element.getAttribute("id"));
            }
            NodeList kids = element.getChildNodes();
            for (int i = 0; i < kids.getLength(); ++i) {
                Node k = kids.item(i);
                if (!(k instanceof Element)) continue;
                logger.log(Level.FINE, "reading node {0}{1} {2}", new Object[]{k.getNodeName(), k.getAttributes().getNamedItem("name"), k.getAttributes().getNamedItem("value")});
                Element e = (Element)k;
                try {
                    PropertyDescriptor pd = (PropertyDescriptor)pp.get(e.getAttribute("name"));
                    if (pd == null) {
                        throw new NullPointerException("expected to find attribute \"name\"");
                    }
                    String slen = e.getAttribute("length");
                    if (slen.length() > 0) {
                        Object c1;
                        int j;
                        int ik;
                        NodeList arraykids;
                        boolean connectorKludge107;
                        clasName = e.getAttribute("class");
                        Class c = scheme.getClass(clasName);
                        int n = Integer.parseInt(e.getAttribute("length"));
                        Object arr = Array.newInstance(c, n);
                        boolean bl = connectorKludge107 = c == Connector.class;
                        if (!connectorKludge107 && DomNode.class.isAssignableFrom(c)) {
                            arraykids = e.getChildNodes();
                            ik = 0;
                            for (j = 0; j < n; ++j) {
                                while (ik < arraykids.getLength() && !(arraykids.item(ik) instanceof Element)) {
                                    ++ik;
                                }
                                if (!(arraykids.item(ik) instanceof Element)) {
                                    throw new ParseException("didn't find " + n + " elements under array item in " + e.getAttribute("name"), 0);
                                }
                                c1 = SerializeUtil.getDomNode((Element)arraykids.item(ik), scheme);
                                ++ik;
                                Array.set(arr, j, c1);
                            }
                            pd.getWriteMethod().invoke((Object)node, arr);
                            continue;
                        }
                        arraykids = e.getChildNodes();
                        ik = 0;
                        for (j = 0; j < n; ++j) {
                            while (ik < arraykids.getLength() && !(arraykids.item(ik) instanceof Element)) {
                                ++ik;
                            }
                            if (!(arraykids.item(ik) instanceof Element)) {
                                throw new ParseException("didn't find " + n + " elements under array item in " + e.getAttribute("name"), 0);
                            }
                            c1 = SerializeUtil.getLeafNode((Element)arraykids.item(ik));
                            ++ik;
                            Array.set(arr, j, c1);
                        }
                        pd.getWriteMethod().invoke((Object)node, arr);
                        continue;
                    }
                    String stype = e.getAttribute("type");
                    if (!stype.equals("DomNode")) {
                        Object child = SerializeUtil.getLeafNode(e);
                        logger.log(Level.FINEST, "leafNode={0} type {1}", new Object[]{child, stype});
                        pd.getWriteMethod().invoke((Object)node, child);
                        continue;
                    }
                    Node childElement = e.getFirstChild();
                    while (!(childElement instanceof Element)) {
                        childElement = childElement.getNextSibling();
                    }
                    DomNode child = SerializeUtil.getDomNode((Element)childElement, scheme);
                    logger.log(Level.FINEST, "firstChild={0}", child);
                    pd.getWriteMethod().invoke((Object)node, child);
                    continue;
                }
                catch (RuntimeException ex) {
                    if (scheme.resolveProperty(e, node)) {
                        logger.log(Level.INFO, "imported {0}", e.getAttribute("name"));
                        continue;
                    }
                    scheme.addUnresolvedProperty(e, node, ex);
                    continue;
                }
                catch (Exception ex) {
                    if (scheme.resolveProperty(e, node)) {
                        logger.log(Level.INFO, "imported {0}", e.getAttribute("name"));
                        continue;
                    }
                    scheme.addUnresolvedProperty(e, node, ex);
                }
            }
            String unres = scheme.describeUnresolved();
            if (unres != null && unres.trim().length() > 0) {
                logger.log(Level.WARNING, "Unresolved: {0}", unres);
            }
            return node;
        }
        catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InstantiationException ex) {
            logger.log(Level.SEVERE, ex.getMessage(), ex);
            throw new RuntimeException(ex);
        }
    }

    static {
        SerializeRegistry.register(BindingModel.class, (SerializeDelegate)new BindingModelSerializeDelegate());
        SerializeRegistry.register(Connector.class, (SerializeDelegate)new ConnectorSerializeDelegate());
        SerializeRegistry.register(Datum.class, (SerializeDelegate)new DatumSerializeDelegate());
        SerializeRegistry.register(Enum.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(Color.class, (SerializeDelegate)new ColorSerializeDelegate());
        SerializeRegistry.register(DasColorBar.Type.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(DefaultPlotSymbol.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(PsymConnector.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(SpectrogramRenderer.RebinnerEnum.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(RenderType.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(MouseModuleType.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(PlotSymbol.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(LegendPosition.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(AnchorPosition.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(BorderType.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(AnchorType.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(ErrorBarType.class, (SerializeDelegate)new TypeSafeEnumSerializeDelegate());
        SerializeRegistry.register(Level.class, (SerializeDelegate)new LevelSerializeDelegate());
    }
}

